/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.BooleanConfigButton;
import de.maxhenkel.voicechat.natives.SpeexManager;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AgcButton
extends BooleanConfigButton {
    private static final Component AUTO = Component.translatable((String)"message.voicechat.gain.auto");
    private static final Component MANUAL = Component.translatable((String)"message.voicechat.gain.manual").withStyle(ChatFormatting.RED);
    private static final Tooltip MANUAL_WARNING = Tooltip.create((Component)Component.translatable((String)"message.voicechat.gain.manual.warning").withStyle(ChatFormatting.RED));
    private final Consumer<Boolean> onChange;

    public AgcButton(int x, int y, int width, int height, Consumer<Boolean> onChange) {
        super(x, y, width, height, VoicechatClient.CLIENT_CONFIG.agc, enabled -> {
            MutableComponent translatable = Component.translatable((String)"message.voicechat.gain", (Object[])new Object[]{enabled != false ? AUTO : MANUAL});
            if (!enabled.booleanValue()) {
                translatable.withStyle(ChatFormatting.RED);
            }
            return translatable;
        });
        this.onChange = onChange;
        if (!SpeexManager.canUseAgc()) {
            this.active = false;
            onChange.accept(false);
        } else {
            onChange.accept((Boolean)this.entry.get());
        }
        this.updateTooltip();
    }

    @Override
    public void onPress(InputWithModifiers inputWithModifiers) {
        super.onPress(inputWithModifiers);
        this.onChange.accept((Boolean)this.entry.get());
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (!((Boolean)this.entry.get()).booleanValue()) {
            this.setTooltip(MANUAL_WARNING);
        } else {
            this.setTooltip(null);
        }
    }
}

